#include "ex94421ademo.h"
#include "ui_ex94421ademo.h"

u8 CardID ;
u32 Status ;

// ------------ constructor & destructor ---------------
ex94421ademo::ex94421ademo(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::ex94421ademo)
{
    int ad_index = 0;
    this->ui->setupUi(this);
    this->main_timer = 0;

    QComboBox *temp_AD_config_comboBox[] = { this->ui->Config00_comboBox, this->ui->Config01_comboBox, this->ui->Config02_comboBox,
                                             this->ui->Config03_comboBox, this->ui->Config04_comboBox, this->ui->Config05_comboBox,
                                             this->ui->Config06_comboBox, this->ui->Config07_comboBox };
    QLineEdit *temp_AD_value_lineEdit[] = { this->ui->AdValue_00_lineEdit, this->ui->AdValue_01_lineEdit, this->ui->AdValue_02_lineEdit,
                                             this->ui->AdValue_03_lineEdit, this->ui->AdValue_04_lineEdit, this->ui->AdValue_05_lineEdit,
                                             this->ui->AdValue_06_lineEdit, this->ui->AdValue_07_lineEdit };
    for( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
      {
        this->AD_config_comboBox[ ad_index ] = temp_AD_config_comboBox[ ad_index ];
        this->AD_config_comboBox[ ad_index ]->addItem("0:0V~5V");
        this->AD_config_comboBox[ ad_index ]->addItem("1:-5V~+5V");
        this->AD_config_comboBox[ ad_index ]->addItem("2:0V~10V");
        this->AD_config_comboBox[ ad_index ]->addItem("3:-10V~+10V");
        this->AD_config_comboBox[ ad_index ]->addItem("255:stop");

        this->AD_value_lineEdit[ ad_index ] = temp_AD_value_lineEdit[ ad_index ];
        this->AD_value_lineEdit[ad_index]->setText("0.00 V");
      }

    // widget setting
    this->ui->Exit_pushButton->setIcon(QIcon( ":/icon/image/exit.ico" ));
    this->ui->StartStop_pushButton->setCheckable(true);
    this->ui->StartStop_pushButton->setIcon(QIcon( ":/icon/image/Run.ico" ));
    this->ui->StartStop_pushButton->setPalette(QPalette(QColor(150,194,255)));

    // initial
    Status = 0;
    for( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
    {
        this->ad_config[ad_index] = 0;
    }

    this->initial_failed = false;
    this->initial_card();
    if ( true == this->initial_failed )
      {
        this->close_timer = 0;
        this->close_timer = startTimer(300);
      }

    // create menu action
    this->ui->menuExit->addAction(this->ui->actionExit);
    this->ui->menuFunction->addAction(this->ui->actionIO);
    this->ui->menuFunction->addAction(this->ui->actionTC);
    this->ui->menuFunction->addAction(this->ui->actionInterrupt);


    // create new form
    this->form_TTL_IO = new TTL_IO_Form(0, Qt::Sheet);
    this->form_TC = new TC_Form(0, Qt::Sheet);
    this->form_Interrupt = new Interrupt_Form(0, Qt::Sheet);
}

ex94421ademo::~ex94421ademo()
{
    qWarning("delete!");

    delete this->form_TTL_IO;
    delete this->form_TC;
    delete this->form_Interrupt;
    delete ui;
}


// ------------ event ---------------
void ex94421ademo::timerEvent ( QTimerEvent *event )
{
    // qWarning("test");
    if ( event->timerId() == this->main_timer )
    {
        this->ad_read();
    }

    if ( event->timerId() == this->close_timer )    // when initial failed
      {
        this->close();
        killTimer( this->close_timer );
      }
}
void ex94421ademo::closeEvent ( QCloseEvent *event )
{
//    EX94421A_IRQ_disable(CardID);
    EX94421A_close();
    event->accept();
}



// ------------ sub-function ---------------
void ex94421ademo::initial_card()
{
    Status = EX94421A_initial();
    if ( Status != 0 )            // Exception process
    {
        switch( QMessageBox::warning( this, QString::fromUtf8 ("EX94421A"),
                                      QString::fromUtf8 ("Initial fail!") + "\n" + "Error #" + QString::number(Status,10),
                                      QMessageBox::Ok, QMessageBox::NoButton, QMessageBox::NoButton ) )
        {
        case QMessageBox::Ok: 		// first button in message box
        {
            // force to exit
        }
        default:
        {
            this->initial_failed = true;
            break;
        }
        }
    }

    this->check_card();
    this->ad_config_update();
}

void ex94421ademo::check_card()
{
    int id_index = 0;
    u16 address;

    for ( id_index = 0; id_index < 16; id_index++ )
    {
        Status = EX94421A_info( id_index, &address);
        if ( NO_ERROR == Status )
        {
            this->ui->CardID_comboBox->addItem( QString::number(id_index,10) );
            CardID = id_index;
        }

    }

}

void ex94421ademo::ad_config_update()
{
    int ad_index = 0;

    for ( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
    {
        Status = EX94421A_AD_config_read( CardID, ad_index, &this->ad_config[ad_index] );
        if ( 255 == this->ad_config[ad_index] )
        {
            this->AD_config_comboBox[ad_index]->setCurrentIndex(4);
        }
        else
        {
            this->AD_config_comboBox[ad_index]->setCurrentIndex(this->ad_config[ad_index]); ;
        }
    }
}

void ex94421ademo::ad_config_set()
{
    int ad_index = 0;

    for ( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
    {
        if ( 4 == this->AD_config_comboBox[ad_index]->currentIndex() )
        {
            Status = EX94421A_AD_config_set( CardID, ad_index, 255 );
        }
        else
        {
            Status = EX94421A_AD_config_set( CardID, ad_index, this->AD_config_comboBox[ad_index]->currentIndex() );
        }
    }
}

void ex94421ademo::ad_read()
{
    int ad_index = 0;
    f32 voltage_data[MAX_AD_NUM] = {0};
    u16 raw_data[MAX_AD_NUM] = {0};
    f64 buffer = 0;
    u16 data[24] = {0};

    //-- read raw data & change to voltage data
    EX94421A_AD_integral_all_read(CardID, data);
        for ( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
        {
            //qWarning("data[%d] %d",ad_index,data[ad_index]);
            change_data_to_voltage(ad_index,data[ad_index],&buffer/*voltage_data[ad_index]*/);
            this->AD_value_lineEdit[ad_index]->setText( QString( "%1 V" ).arg ( buffer, 0, 'f', 2 ));
        }

    //-- read voltage data directly
//    for ( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
//    {
//        Status = EX94421A_AD_value_read ( CardID, ad_index, &voltage_data[ad_index] );
//        this->AD_value_lineEdit[ad_index]->setText( QString( "%1 V" ).arg ( voltage_data[ad_index], 0, 'f', 2 ));
//    }
}





void ex94421ademo::change_data_to_voltage(u8 channel,u16 data,f64 *voltage)
{
    const f64 denominator = 65536.0;

    switch ( this->AD_config_comboBox[channel]->currentIndex() )
    {
    case 0:
        *voltage = (f64)data * (5.0 / denominator);
        break;
    case 1:
        *voltage = (f64)((i16)data) * (10.0 / denominator);
        break;
    case 2:
        *voltage = (f64)data * (10.0 / denominator);
        break;
    case 3:
        *voltage = (f64)((i16)data) * (20.0 / denominator);
        break;
    case 4:
        *voltage = 0.0;
        break;

    }
}









// ------------ slot ---------------
void ex94421ademo::on_Exit_pushButton_clicked()
{
    this->close();
}

void ex94421ademo::on_StartStop_pushButton_toggled(bool checked)
{
    int ad_index = 0;

    if ( true == checked )
    {
//        qWarning("checked");
        // widget setting.
        this->ui->StartStop_pushButton->setIcon(QIcon( ":/icon/image/Stop.ico" ));
        this->ui->StartStop_pushButton->setPalette(QPalette(QColor(255,210,245)));

        for( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
        {
            this->AD_config_comboBox[ad_index]->setEnabled(false);
        }

        // start timer to work.
        this->ad_config_set();
        Status = EX94421A_AD_integral_start( CardID, this->ui->AdMode_comboBox->currentIndex() );
        this->main_timer = startTimer(100);
    }
    else
    {
//        qWarning("un-checked");
        // widget setting
        this->ui->StartStop_pushButton->setIcon(QIcon( ":/icon/image/Run.ico" ));
        this->ui->StartStop_pushButton->setPalette(QPalette(QColor(150,194,255)));

        for( ad_index = 0; ad_index < MAX_AD_NUM; ad_index++ )
        {
            this->AD_config_comboBox[ad_index]->setEnabled(true);
        }

        // stop timer.
        EX94421A_AD_integral_stop( CardID );
        killTimer( this->main_timer );
        this->main_timer = 0;
    }
}

void ex94421ademo::on_CardID_comboBox_currentIndexChanged(int index)
{
    CardID = this->ui->CardID_comboBox->itemText(index).toInt();
    qWarning("card id = %d", CardID);
}


void ex94421ademo::on_actionExit_triggered()
{
    this->close();
}



void ex94421ademo::on_actionIO_triggered()
{
    this->form_TTL_IO->show();
}

void ex94421ademo::on_actionTC_triggered()
{
    this->form_TC->show();
}

void ex94421ademo::on_actionInterrupt_triggered()
{
    this->form_Interrupt->show();
}

void ex94421ademo::on_AdMode_comboBox_currentIndexChanged(int index)
{
    this->ui->StartStop_pushButton->setChecked(false);
}
